/*
 * Decompiled with CFR 0.152.
 */
package org.syntax.jedit.tokenmarker;

import javax.swing.text.Segment;
import org.syntax.jedit.KeywordMap;
import org.syntax.jedit.tokenmarker.TokenMarker;

public class CTokenMarker
extends TokenMarker {
    private static KeywordMap cKeywords;
    private boolean cpp;
    private KeywordMap keywords;
    private int lastOffset;
    private int lastKeyword;

    public CTokenMarker() {
        this(true, CTokenMarker.getKeywords());
    }

    public CTokenMarker(boolean bl, KeywordMap keywordMap) {
        this.cpp = bl;
        this.keywords = keywordMap;
    }

    @Override
    public byte markTokensImpl(byte by, Segment segment, int n) {
        int n2;
        char[] cArray = segment.array;
        this.lastOffset = n2 = segment.offset;
        this.lastKeyword = n2;
        int n3 = segment.count + n2;
        boolean bl = false;
        block21: for (int i = n2; i < n3; ++i) {
            int n4 = i + 1;
            char c = cArray[i];
            if (c == '\\') {
                bl = !bl;
                continue;
            }
            switch (by) {
                case 0: {
                    switch (c) {
                        case '#': {
                            if (bl) {
                                bl = false;
                                break;
                            }
                            if (!this.cpp) continue block21;
                            if (this.doKeyword(segment, i, c)) break;
                            this.addToken(i - this.lastOffset, by);
                            this.addToken(n3 - i, (byte)7);
                            this.lastOffset = this.lastKeyword = n3;
                            break block21;
                        }
                        case '\"': {
                            this.doKeyword(segment, i, c);
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, by);
                            by = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(segment, i, c);
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, by);
                            by = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case ':': {
                            if (this.lastKeyword == n2) {
                                if (this.doKeyword(segment, i, c)) break;
                                bl = false;
                                this.addToken(n4 - this.lastOffset, (byte)5);
                                this.lastOffset = this.lastKeyword = n4;
                                break;
                            }
                            if (!this.doKeyword(segment, i, c)) continue block21;
                            break;
                        }
                        case '/': {
                            bl = false;
                            this.doKeyword(segment, i, c);
                            if (n3 - i <= 1) continue block21;
                            switch (cArray[n4]) {
                                case '*': {
                                    this.addToken(i - this.lastOffset, by);
                                    this.lastOffset = this.lastKeyword = i;
                                    if (n3 - i > 2 && cArray[i + 2] == '*') {
                                        by = (byte)2;
                                        break;
                                    }
                                    by = 1;
                                    break;
                                }
                                case '/': {
                                    this.addToken(i - this.lastOffset, by);
                                    this.addToken(n3 - i, (byte)1);
                                    this.lastOffset = this.lastKeyword = n3;
                                    break block21;
                                }
                            }
                            continue block21;
                        }
                        default: {
                            bl = false;
                            if (Character.isLetterOrDigit(c) || c == '_' || c == '@') continue block21;
                            this.doKeyword(segment, i, c);
                            break;
                        }
                    }
                    continue block21;
                }
                case 1: 
                case 2: {
                    bl = false;
                    if (c != '*' || n3 - i <= 1 || cArray[n4] != '/') continue block21;
                    this.addToken(++i + 1 - this.lastOffset, by);
                    by = 0;
                    this.lastOffset = this.lastKeyword = i + 1;
                    continue block21;
                }
                case 3: {
                    if (bl) {
                        bl = false;
                        continue block21;
                    }
                    if (c != '\"') continue block21;
                    this.addToken(n4 - this.lastOffset, by);
                    by = 0;
                    this.lastOffset = this.lastKeyword = n4;
                    continue block21;
                }
                case 4: {
                    if (bl) {
                        bl = false;
                        continue block21;
                    }
                    if (c != '\'') continue block21;
                    this.addToken(n4 - this.lastOffset, (byte)3);
                    by = 0;
                    this.lastOffset = this.lastKeyword = n4;
                    continue block21;
                }
                default: {
                    throw new InternalError("Invalid state: " + by);
                }
            }
        }
        if (by == 0) {
            this.doKeyword(segment, n3, '\u0000');
        }
        switch (by) {
            case 3: 
            case 4: {
                this.addToken(n3 - this.lastOffset, (byte)10);
                by = 0;
                break;
            }
            case 7: {
                this.addToken(n3 - this.lastOffset, by);
                if (!bl) {
                    by = 0;
                }
            }
            default: {
                this.addToken(n3 - this.lastOffset, by);
            }
        }
        return by;
    }

    public static KeywordMap getKeywords() {
        if (cKeywords == null) {
            cKeywords = new KeywordMap(false);
            cKeywords.add("char", (byte)8);
            cKeywords.add("double", (byte)8);
            cKeywords.add("enum", (byte)8);
            cKeywords.add("float", (byte)8);
            cKeywords.add("int", (byte)8);
            cKeywords.add("long", (byte)8);
            cKeywords.add("short", (byte)8);
            cKeywords.add("signed", (byte)8);
            cKeywords.add("struct", (byte)8);
            cKeywords.add("typedef", (byte)8);
            cKeywords.add("union", (byte)8);
            cKeywords.add("unsigned", (byte)8);
            cKeywords.add("void", (byte)8);
            cKeywords.add("auto", (byte)6);
            cKeywords.add("const", (byte)6);
            cKeywords.add("extern", (byte)6);
            cKeywords.add("register", (byte)6);
            cKeywords.add("static", (byte)6);
            cKeywords.add("volatile", (byte)6);
            cKeywords.add("break", (byte)6);
            cKeywords.add("case", (byte)6);
            cKeywords.add("continue", (byte)6);
            cKeywords.add("default", (byte)6);
            cKeywords.add("do", (byte)6);
            cKeywords.add("else", (byte)6);
            cKeywords.add("for", (byte)6);
            cKeywords.add("goto", (byte)6);
            cKeywords.add("if", (byte)6);
            cKeywords.add("return", (byte)6);
            cKeywords.add("sizeof", (byte)6);
            cKeywords.add("switch", (byte)6);
            cKeywords.add("while", (byte)6);
            cKeywords.add("asm", (byte)7);
            cKeywords.add("asmlinkage", (byte)7);
            cKeywords.add("far", (byte)7);
            cKeywords.add("huge", (byte)7);
            cKeywords.add("inline", (byte)7);
            cKeywords.add("near", (byte)7);
            cKeywords.add("pascal", (byte)7);
            cKeywords.add("true", (byte)4);
            cKeywords.add("false", (byte)4);
            cKeywords.add("NULL", (byte)4);
        }
        return cKeywords;
    }

    private boolean doKeyword(Segment segment, int n, char c) {
        int n2 = n + 1;
        int n3 = n - this.lastKeyword;
        byte by = this.keywords.lookup(segment, this.lastKeyword, n3);
        if (by != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(n3, by);
            this.lastOffset = n;
        }
        this.lastKeyword = n2;
        return false;
    }
}

