/*
 * Decompiled with CFR 0.152.
 */
package org.syntax.jedit;

import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;
import org.syntax.jedit.tokenmarker.TokenMarker;

public class SyntaxDocument
extends PlainDocument {
    protected TokenMarker tokenMarker;

    public TokenMarker getTokenMarker() {
        return this.tokenMarker;
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if ("\n".equals(string)) {
            String string2 = this.getLineTabString(n - 1);
            if (n >= 1 && this.getText(n - 1, 1).equals("{")) {
                string2 = string2 + "\t";
            }
            super.insertString(n, string + string2, attributeSet);
        } else if ("}".equals(string) && n >= 1 && this.getText(n - 1, 1).equals("\t")) {
            this.remove(n - 1, 1);
            super.insertString(n - 1, string, attributeSet);
        } else {
            super.insertString(n, string, attributeSet);
        }
    }

    private String getLineTabString(int n) throws BadLocationException {
        String string = this.getText(0, this.getLength());
        int n2 = string.lastIndexOf(10, n);
        String string2 = "";
        for (int i = n2 + 1; i < string.length() && (string.charAt(i) == '\t' || string.charAt(i) == ' '); ++i) {
            string2 = string2 + string.charAt(i);
        }
        return string2;
    }

    public void setTokenMarker(TokenMarker tokenMarker) {
        this.tokenMarker = tokenMarker;
        if (tokenMarker == null) {
            return;
        }
        this.tokenMarker.insertLines(0, this.getDefaultRootElement().getElementCount());
        this.tokenizeLines();
    }

    public void tokenizeLines() {
        this.tokenizeLines(0, this.getDefaultRootElement().getElementCount());
    }

    public void tokenizeLines(int n, int n2) {
        if (this.tokenMarker == null || !this.tokenMarker.supportsMultilineTokens()) {
            return;
        }
        Segment segment = new Segment();
        Element element = this.getDefaultRootElement();
        n2 += n;
        try {
            for (int i = n; i < n2; ++i) {
                Element element2 = element.getElement(i);
                int n3 = element2.getStartOffset();
                this.getText(n3, element2.getEndOffset() - n3 - 1, segment);
                this.tokenMarker.markTokens(segment, i);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void beginCompoundEdit() {
    }

    public void endCompoundEdit() {
    }

    public void addUndoableEdit(UndoableEdit undoableEdit) {
    }

    @Override
    protected void fireInsertUpdate(DocumentEvent documentEvent) {
        DocumentEvent.ElementChange elementChange;
        if (this.tokenMarker != null && (elementChange = documentEvent.getChange(this.getDefaultRootElement())) != null) {
            this.tokenMarker.insertLines(elementChange.getIndex() + 1, elementChange.getChildrenAdded().length - elementChange.getChildrenRemoved().length);
        }
        super.fireInsertUpdate(documentEvent);
    }

    @Override
    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
        DocumentEvent.ElementChange elementChange;
        if (this.tokenMarker != null && (elementChange = documentEvent.getChange(this.getDefaultRootElement())) != null) {
            this.tokenMarker.deleteLines(elementChange.getIndex() + 1, elementChange.getChildrenRemoved().length - elementChange.getChildrenAdded().length);
        }
        super.fireRemoveUpdate(documentEvent);
    }
}

