/*
 * Decompiled with CFR 0.152.
 */
package data_structures;

import data_structures.Location;

public class PiError {
    private errorTypeT errorType;
    private String msg;
    private Location location;

    private PiError(errorTypeT errorTypeT2, String string, Location location) {
        this.errorType = errorTypeT2;
        this.msg = string;
        this.location = location;
    }

    public static PiError makeError(String string, String string2, Location location) {
        if ("syntax_error".equals(string)) {
            return new PiError(errorTypeT.Syntax, string2, location);
        }
        if ("semantic_error".equals(string)) {
            return new PiError(errorTypeT.Semantic, string2, location);
        }
        if ("compiler_error".equals(string) && location == null) {
            return new PiError(errorTypeT.Compiler, string2, null);
        }
        throw new IllegalArgumentException("Illegal type passed to PiError: " + string);
    }

    public String getMessage() {
        return this.getTypeString() + "<p>" + this.msg;
    }

    private String getTypeString() {
        if (this.errorType == errorTypeT.Syntax) {
            return "Syntax error:";
        }
        if (this.errorType == errorTypeT.Semantic) {
            return "Semantic error:";
        }
        return "Compiler error:";
    }

    public Location getLocation() {
        return this.location;
    }

    private static enum errorTypeT {
        Syntax,
        Semantic,
        Compiler;

    }
}

