/*
 * Decompiled with CFR 0.152.
 */
package data_structures;

import java.util.List;

public class Location {
    private Position start;
    private Position end;

    public Location(int n, int n2, int n3, int n4, int n5, int n6) {
        this.start = new Position(n, n2, n3);
        this.end = new Position(n4, n5, n6);
    }

    private Location(Position position, Position position2) {
        this.start = position;
        this.end = position2;
    }

    public static Location mergeLocations(List<Location> list) {
        Position position = null;
        Position position2 = null;
        for (Location location : list) {
            if (location.isDummy()) continue;
            if (position == null) {
                position = location.start;
                position2 = location.end;
                continue;
            }
            if (location.start.compareTo(position) < 0) {
                position = location.start;
            }
            if (location.end.compareTo(position2) <= 0) continue;
            position2 = location.end;
        }
        if (position == null) {
            return Location.getDummy();
        }
        return new Location(position, position2);
    }

    public int getStartByte() {
        return this.start.getByte();
    }

    public int getEndByte() {
        return this.end.getByte();
    }

    public int getStartRow() {
        return this.start.getRow();
    }

    public int getEndRow() {
        return this.end.getRow();
    }

    public int getStartCol() {
        return this.start.getCol();
    }

    public int getEndCol() {
        return this.end.getCol();
    }

    public boolean isDummy() {
        return this.start.getByte() == 0 && this.end.getByte() == 0;
    }

    public static Location getDummy() {
        return new Location(0, 0, 0, 0, 0, 0);
    }

    private class Position
    implements Comparable {
        private int byteNum;
        private int rowNum;
        private int colNum;

        public Position(int n, int n2, int n3) {
            this.byteNum = n;
            this.rowNum = n2;
            this.colNum = n3;
        }

        public int compareTo(Object object) {
            return this.byteNum - ((Position)object).byteNum;
        }

        public int getByte() {
            return this.byteNum;
        }

        public int getRow() {
            return this.rowNum;
        }

        public int getCol() {
            return this.colNum;
        }
    }
}

