/*
 * Decompiled with CFR 0.152.
 */
import data_structures.BasicPath;
import data_structures.Conjunct;
import data_structures.Counterexample;
import data_structures.Function;
import data_structures.Location;
import data_structures.PiError;
import data_structures.Step;
import data_structures.Termination;
import data_structures.VerificationAtom;
import data_structures.VerificationAtomCollection;
import data_structures.VerificationCondition;
import data_structures.VerificationResult;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ServerResponseParser {
    private PiGui piGui;
    private DocumentBuilder builder;

    public ServerResponseParser(PiGui piGui) {
        this.piGui = piGui;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            this.builder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
    }

    public String[] parse(String string, String string2) {
        Document document = null;
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        try {
            document = this.builder.parse(inputSource);
            stringReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        Node node = document.getFirstChild();
        NodeList nodeList = node.getChildNodes();
        Node node2 = null;
        String[] stringArray = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            if (node3.getNodeName().equals("result")) {
                node2 = node3;
            }
            if (!node3.getNodeName().equals("messages")) continue;
            stringArray = this.parseMessages(node3);
        }
        if (node2 != null) {
            String string3 = node2.getAttributes().getNamedItem("status").getTextContent();
            if (string3.equals("valid") || string3.equals("invalid") || string3.equals("unknown") || string3.equals("timeout")) {
                this.parseNormal(node2, string2);
            } else if (string3.equals("error")) {
                this.parseErrors(node2);
            } else if (string3.equals("compiler_error")) {
                this.parseCompilerError(node2);
            }
        }
        return stringArray;
    }

    private void parseNormal(Node node, String string) {
        String string2 = node.getAttributes().getNamedItem("status").getTextContent();
        ArrayList<Function> arrayList = new ArrayList<Function>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!"function".equals(node2.getNodeName())) continue;
            arrayList.add(this.parseFunction(node2));
        }
        VerificationResult verificationResult = new VerificationResult(string, this.validityStringToValidity(string2), arrayList);
        this.piGui.handleVerificationResult(verificationResult);
    }

    private VerificationResult.validityT validityStringToValidity(String string) {
        if (string.equals("valid")) {
            return VerificationResult.validityT.VALID;
        }
        if (string.equals("invalid")) {
            return VerificationResult.validityT.INVALID;
        }
        if (string.equals("unknown")) {
            return VerificationResult.validityT.UNKNOWN;
        }
        if (string.equals("timeout")) {
            return VerificationResult.validityT.TIMEOUT;
        }
        throw new RuntimeException("Unrecognized validity type.");
    }

    private String[] parseMessages(Node node) {
        ArrayList<String> arrayList = new ArrayList<String>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals("message")) continue;
            arrayList.add(node2.getTextContent());
        }
        return arrayList.toArray(new String[0]);
    }

    private Function parseFunction(Node node) {
        String string = node.getAttributes().getNamedItem("name").getTextContent();
        String string2 = node.getAttributes().getNamedItem("status").getTextContent();
        VerificationAtomCollection verificationAtomCollection = null;
        Termination termination = null;
        Location location = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if ("correctness".equals(node2.getNodeName())) {
                verificationAtomCollection = this.parseVerificationAtomCollection(node2, "Correctness");
            }
            if ("termination".equals(node2.getNodeName())) {
                termination = this.parseTermination(node2);
            }
            if (!"location".equals(node2.getNodeName())) continue;
            location = this.parseLocation(node2);
        }
        if (verificationAtomCollection == null || location == null) {
            throw new RuntimeException("Invalid function tag");
        }
        return new Function(string, this.validityStringToValidity(string2), verificationAtomCollection, termination, location);
    }

    private VerificationAtomCollection parseVerificationAtomCollection(Node node, String string) {
        String string2 = node.getAttributes().getNamedItem("status").getTextContent();
        VerificationResult.validityT validityT2 = this.validityStringToValidity(string2);
        ArrayList<VerificationAtom> arrayList = new ArrayList<VerificationAtom>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!"verification_atom".equals(node2.getNodeName())) continue;
            arrayList.add(this.parseVerificationAtom(node2));
        }
        if (arrayList.size() == 0) {
            throw new RuntimeException("List of atoms is empty");
        }
        return new VerificationAtomCollection(validityT2, arrayList, string);
    }

    private Termination parseTermination(Node node) {
        String string = node.getAttributes().getNamedItem("status").getTextContent();
        VerificationResult.validityT validityT2 = this.validityStringToValidity(string);
        VerificationAtomCollection verificationAtomCollection = null;
        VerificationAtomCollection verificationAtomCollection2 = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if ("decreasing".equals(node2.getNodeName())) {
                verificationAtomCollection = this.parseVerificationAtomCollection(node2, "Decreasing");
            }
            if (!"nonnegative".equals(node2.getNodeName())) continue;
            verificationAtomCollection2 = this.parseVerificationAtomCollection(node2, "Nonnegative");
        }
        if (verificationAtomCollection == null || verificationAtomCollection2 == null) {
            throw new RuntimeException("Invalid termination tag");
        }
        return new Termination(validityT2, verificationAtomCollection, verificationAtomCollection2);
    }

    private VerificationCondition parseVerificationCondition(Node node, VerificationResult.validityT validityT2) {
        NodeList nodeList = node.getChildNodes();
        ArrayList<Conjunct[]> arrayList = new ArrayList<Conjunct[]>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals("implies")) continue;
            NodeList nodeList2 = node2.getChildNodes();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Object object;
                Node node3 = nodeList2.item(j);
                if (!node3.getNodeName().equals("conjunct")) continue;
                String string = null;
                Location location = null;
                Boolean bl = null;
                VerificationResult.validityT validityT3 = null;
                NodeList nodeList3 = node3.getChildNodes();
                for (int k = 0; k < nodeList3.getLength(); ++k) {
                    object = nodeList3.item(k);
                    if (object.getNodeName().equals("text")) {
                        string = object.getTextContent();
                    }
                    if (!object.getNodeName().equals("location")) continue;
                    location = this.parseLocation((Node)object);
                }
                NamedNodeMap namedNodeMap = node3.getAttributes();
                for (int k = 0; k < namedNodeMap.getLength(); ++k) {
                    Node node4 = namedNodeMap.item(k);
                    if (node4.getNodeName().equals("status")) {
                        validityT3 = VerificationResult.parseValidity(node4.getNodeValue());
                    }
                    if (!node4.getNodeName().equals("in_inductive_core")) continue;
                    bl = new Boolean(Boolean.parseBoolean(node4.getNodeValue()));
                }
                if (string == null) {
                    throw new RuntimeException("No text node in VC conjunct xml");
                }
                if (location == null) {
                    throw new RuntimeException("No location node in VC conjunct xml");
                }
                object = new Conjunct(string, validityT3, bl, location);
                arrayList2.add(object);
            }
            arrayList.add(arrayList2.toArray(new Conjunct[0]));
        }
        return new VerificationCondition((Conjunct[][])arrayList.toArray((T[])new Conjunct[0][]), validityT2);
    }

    private VerificationAtom parseVerificationAtom(Node node) {
        String string = node.getAttributes().getNamedItem("status").getTextContent();
        String string2 = node.getAttributes().getNamedItem("name").getTextContent();
        VerificationResult.validityT validityT2 = this.validityStringToValidity(string);
        BasicPath basicPath = null;
        VerificationCondition verificationCondition = null;
        Counterexample counterexample = null;
        Location location = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if ("basic_path".equals(node2.getNodeName())) {
                basicPath = this.parseBasicPath(node2);
            }
            if ("vc".equals(node2.getNodeName())) {
                verificationCondition = this.parseVerificationCondition(node2, validityT2);
            }
            if ("counterexample".equals(node2.getNodeName())) {
                counterexample = this.parseCounterexample(node2);
            }
            if (!"location".equals(node2.getNodeName())) continue;
            location = this.parseLocation(node2);
        }
        if (verificationCondition == null || verificationCondition.getValidity() == VerificationResult.validityT.INVALID && counterexample == null) {
            throw new RuntimeException("Invalid verification_atom tag");
        }
        return new VerificationAtom(basicPath, verificationCondition, validityT2, counterexample, string2, location);
    }

    private BasicPath parseBasicPath(Node node) {
        ArrayList<Step> arrayList = new ArrayList<Step>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!"step".equals(node2.getNodeName())) continue;
            arrayList.add(this.parseStep(node2));
        }
        return new BasicPath(arrayList);
    }

    private Step parseStep(Node node) {
        String string = node.getAttributes().getNamedItem("type").getTextContent();
        String string2 = null;
        Location location = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if ("location".equals(node2.getNodeName())) {
                location = this.parseLocation(node2);
            }
            if (!"text".equals(node2.getNodeName())) continue;
            string2 = node2.getTextContent();
        }
        if (string == null || string2 == null || location == null) {
            throw new RuntimeException("Invalid step tag");
        }
        return new Step(string, string2, location);
    }

    private Counterexample parseCounterexample(Node node) {
        ArrayList<Counterexample.Variable> arrayList = new ArrayList<Counterexample.Variable>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!"var".equals(node2.getNodeName())) continue;
            arrayList.add(this.parseVariable(node2));
        }
        return new Counterexample(arrayList);
    }

    private Counterexample.Variable parseVariable(Node node) {
        String string = node.getAttributes().getNamedItem("text").getTextContent();
        Location location = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!"location".equals(node2.getNodeName())) continue;
            location = this.parseLocation(node2);
        }
        if (string == null) {
            throw new RuntimeException("Invalid var tag");
        }
        return new Counterexample.Variable(string, location);
    }

    private Location parseLocation(Node node) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if ("start".equals(node2.getNodeName())) {
                n = Integer.valueOf(node2.getAttributes().getNamedItem("row").getTextContent());
                n2 = Integer.valueOf(node2.getAttributes().getNamedItem("col").getTextContent());
                n5 = Integer.valueOf(node2.getAttributes().getNamedItem("byte").getTextContent());
            }
            if (!"end".equals(node2.getNodeName())) continue;
            n3 = Integer.valueOf(node2.getAttributes().getNamedItem("row").getTextContent());
            n4 = Integer.valueOf(node2.getAttributes().getNamedItem("col").getTextContent());
            n6 = Integer.valueOf(node2.getAttributes().getNamedItem("byte").getTextContent());
        }
        if (n == -1 || n2 == -1 || n3 == -1 || n4 == -1 || n5 == -1 || n6 == -1) {
            throw new RuntimeException("Invalid location tag");
        }
        return new Location(n5, n, n2, n6, n3, n4);
    }

    private void parseErrors(Node node) {
        ArrayList<PiError> arrayList = new ArrayList<PiError>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!"error".equals(node2.getNodeName())) continue;
            arrayList.add(this.parseError(node2));
        }
        this.piGui.handleError(arrayList);
    }

    private PiError parseError(Node node) {
        String string = node.getAttributes().getNamedItem("type").getTextContent();
        String string2 = null;
        Location location = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if ("location".equals(node2.getNodeName())) {
                location = this.parseLocation(node2);
            }
            if (!"message".equals(node2.getNodeName())) continue;
            string2 = node2.getTextContent();
        }
        if (string == null || string2 == null || !string.equals("compiler_error") && location == null) {
            throw new RuntimeException("Invalid error tag");
        }
        return PiError.makeError(string, string2, location);
    }

    private void parseCompilerError(Node node) {
        PiError piError = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!"error".equals(node2.getNodeName())) continue;
            piError = this.parseError(node2);
        }
        if (piError == null) {
            throw new RuntimeException("Invalid compiler_error tag");
        }
        this.piGui.handleCompilerError(piError);
    }
}

