/*
 * Decompiled with CFR 0.152.
 */
import data_structures.Conjunct;
import data_structures.Location;
import data_structures.VerificationCondition;
import data_structures.VerificationResult;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PiVCPane
extends JPanel {
    private JList list;
    private DefaultListModel model;
    private PiCode piCode;
    private ListSelector selectionModel;

    public PiVCPane(PiCode piCode) {
        this.piCode = piCode;
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        this.selectionModel = new ListSelector();
        this.initList();
    }

    public void setNothing() {
        this.clear();
        this.model.addElement("<html><i>Use the above pane to select a VC</i></html>");
    }

    private void initList() {
        this.list.setCellRenderer(new MyListCellRenderer());
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                int n = PiVCPane.this.list.locationToIndex(mouseEvent.getPoint());
                if (n != -1 && PiVCPane.this.list.getCellBounds(n, n).contains(mouseEvent.getPoint())) {
                    PiVCPane.this.selectionModel.select(n);
                    Object e = PiVCPane.this.list.getSelectedValue();
                    if (e != null) {
                        PiVCPane.this.conjunctClicked(e);
                    }
                } else {
                    PiVCPane.this.selectionModel.clearSelection();
                    PiVCPane.this.conjunctClicked(null);
                }
            }
        });
        this.list.setSelectionModel(this.selectionModel);
    }

    private void conjunctClicked(Object object) {
        if (object == null || !(object instanceof Conjunct)) {
            this.piCode.removeAllHighlights();
        } else {
            Location location = ((Conjunct)object).getLocation();
            if (location != null) {
                this.piCode.highlight(location, PiCode.yellowHP);
            }
        }
    }

    public JScrollPane getPiVCPaneInScrollPane() {
        return new JScrollPane(this.list);
    }

    public void setVC(VerificationCondition verificationCondition) {
        this.clear();
        Conjunct[][] conjunctArray = verificationCondition.getConjuncts();
        for (int i = 0; i < conjunctArray.length; ++i) {
            for (int j = 0; j < conjunctArray[i].length; ++j) {
                Conjunct conjunct = conjunctArray[i][j];
                String string = PiVCPane.sanitizeHTML(conjunct.str);
                String string2 = "black";
                if (conjunct.status != null) {
                    string2 = conjunct.status.equals((Object)VerificationResult.validityT.VALID) ? "green" : (conjunct.status.equals((Object)VerificationResult.validityT.INVALID) ? "red" : (conjunct.status.equals((Object)VerificationResult.validityT.TIMEOUT) ? "gray" : "yellow"));
                }
                string = "<font color='" + string2 + "'>" + string + "</font>";
                if (conjunct.inInductiveCore != null && !conjunct.inInductiveCore.booleanValue()) {
                    string = "<i>" + string + "</i>";
                }
                if (conjunct.inInductiveCore != null && conjunct.inInductiveCore.booleanValue()) {
                    string = "<b>" + string + "</b>";
                }
                if (j != conjunctArray[i].length - 1) {
                    string = string + " &&";
                }
                string = "&nbsp;&nbsp;&nbsp;" + string;
                conjunct.setDisplayHTML(string);
                this.model.addElement(conjunct);
            }
            if (i == conjunctArray.length - 1) continue;
            this.model.addElement("-&gt;");
        }
    }

    public void clear() {
        this.model.clear();
    }

    public static String sanitizeHTML(String string) {
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        return string;
    }

    public void increaseFont() {
        this.list.setFont(new Font("Droid Sans", 0, this.list.getFont().getSize() + 2));
    }

    public void decreaseFont() {
        if (this.list.getFont().getSize() > 10) {
            this.list.setFont(new Font("Droid Sans", 0, this.list.getFont().getSize() - 2));
        }
    }

    private static class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            String string = "";
            if (object instanceof String) {
                string = (String)object;
            } else if (object instanceof Conjunct) {
                string = ((Conjunct)object).getDisplayHTML();
            } else {
                throw new RuntimeException("unexpected list elem type");
            }
            this.setText("<html>" + string + "</html>");
            return this;
        }
    }
}

