/*
 * Decompiled with CFR 0.152.
 */
import data_structures.BasicPath;
import data_structures.Counterexample;
import data_structures.Function;
import data_structures.Step;
import data_structures.Termination;
import data_structures.VerificationAtom;
import data_structures.VerificationAtomCollection;
import data_structures.VerificationCondition;
import data_structures.VerificationResult;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class PiTree
extends JPanel {
    private static final int ROW_LEFT_GRACE_SPACE = 17;
    private DefaultTreeModel treeModel = new DefaultTreeModel(this.root);
    private JTree tree = new JTree(this.treeModel);
    private DefaultMutableTreeNode root = null;
    private PiGui piGui;
    private PiCode piCode;
    private DefaultMutableTreeNode selectedNode;
    private DefaultMutableTreeNode prevSelectedNode;
    private TreeSet<TreePath> viewableObjects;
    private boolean isExpandingNewlyAddedObjects;
    private static PiObjectComparator piObjectComparator = new PiObjectComparator();

    public PiTree(PiGui piGui, PiCode piCode) {
        this.piGui = piGui;
        this.piCode = piCode;
        this.prevSelectedNode = null;
        this.selectedNode = null;
        this.viewableObjects = new TreeSet<TreePath>(piObjectComparator);
        this.isExpandingNewlyAddedObjects = false;
        this.initTree();
    }

    private void initTree() {
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                int n = PiTree.this.tree.getClosestRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n == -1) {
                    return;
                }
                Rectangle rectangle = PiTree.this.tree.getRowBounds(n);
                if (rectangle.contains(mouseEvent.getPoint())) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)PiTree.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY()).getLastPathComponent();
                    if (defaultMutableTreeNode == PiTree.this.selectedNode) {
                        PiTree.this.nodeSelected(defaultMutableTreeNode.getUserObject());
                    }
                } else if ((double)mouseEvent.getX() > rectangle.getMaxX() || (double)mouseEvent.getY() > rectangle.getMaxY() || (double)mouseEvent.getX() < rectangle.getMinX() - 17.0) {
                    PiTree.this.prevSelectedNode = PiTree.this.selectedNode;
                    PiTree.this.selectedNode = null;
                    PiTree.this.tree.clearSelection();
                    PiTree.this.nodeSelected(null);
                    PiTree.this.piGui.nodeSelected(null);
                }
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)PiTree.this.tree.getLastSelectedPathComponent();
                PiTree.this.prevSelectedNode = PiTree.this.selectedNode;
                PiTree.this.selectedNode = defaultMutableTreeNode;
                Object object = defaultMutableTreeNode == null ? null : defaultMutableTreeNode.getUserObject();
                PiTree.this.piGui.nodeSelected(object);
                if (defaultMutableTreeNode == null) {
                    return;
                }
                PiTree.this.nodeSelected(object);
            }
        });
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                TreePath treePath = treeExpansionEvent.getPath();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                Object object = defaultMutableTreeNode.getUserObject();
                PiTree.this.viewableObjects.add(treePath);
                if (PiTree.this.isExpandingNewlyAddedObjects) {
                    return;
                }
                if (object instanceof Function && defaultMutableTreeNode.getChildCount() == 1) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
                    PiTree.this.tree.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
                } else if (object instanceof VerificationAtom) {
                    for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                        PiTree.this.tree.expandPath(new TreePath(defaultMutableTreeNode3.getPath()));
                    }
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                TreePath treePath = treeExpansionEvent.getPath();
                this.hideObject((DefaultMutableTreeNode)treePath.getLastPathComponent());
            }

            private void hideObject(DefaultMutableTreeNode defaultMutableTreeNode) {
                PiTree.this.viewableObjects.remove(new TreePath(defaultMutableTreeNode.getPath()));
                for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                    this.hideObject((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i));
                }
            }
        });
        this.tree.setCellRenderer(new MyTreeCellRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(true);
        this.tree.setEditable(false);
        this.tree.setRowHeight(0);
    }

    public JScrollPane getTreeInScrollPane() {
        return new JScrollPane(this.tree);
    }

    public void handleVerificationResult(VerificationResult verificationResult) {
        this.root = new DefaultMutableTreeNode(verificationResult);
        this.treeModel.setRoot(this.root);
        this.addFunctions(verificationResult);
        this.expandPreviouslyExpandedNodes();
    }

    private void addFunctions(VerificationResult verificationResult) {
        for (int i = 0; i < verificationResult.getNumFunctions(); ++i) {
            Function function = verificationResult.getFunction(i);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(function);
            this.treeModel.insertNodeInto(defaultMutableTreeNode, this.root, this.root.getChildCount());
            VerificationAtomCollection verificationAtomCollection = function.getCorrectness();
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(verificationAtomCollection);
            this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            this.addVerificationAtomCollection(verificationAtomCollection, defaultMutableTreeNode2);
            Termination termination = function.getTermination();
            if (termination != null) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(termination);
                this.treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                this.addTermination(termination, defaultMutableTreeNode3);
            }
            this.tree.makeVisible(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    private void addVerificationAtomCollection(VerificationAtomCollection verificationAtomCollection, DefaultMutableTreeNode defaultMutableTreeNode) {
        for (int i = 0; i < verificationAtomCollection.getNumAtoms(); ++i) {
            VerificationAtom verificationAtom = verificationAtomCollection.getAtom(i);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(verificationAtom);
            this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            BasicPath basicPath = verificationAtom.getBP();
            if (basicPath != null) {
                this.addSteps(basicPath, defaultMutableTreeNode2);
            }
            if (verificationAtom.getValidity() != VerificationResult.validityT.INVALID) continue;
            this.addCounterexample(verificationAtom.getCounterexample(), defaultMutableTreeNode2);
        }
    }

    private void addSteps(BasicPath basicPath, DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Steps");
        this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        for (int i = 0; i < basicPath.getNumSteps(); ++i) {
            Step step = basicPath.getStep(i);
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(step);
            this.treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
        }
    }

    private void addCounterexample(Counterexample counterexample, DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Counterexample");
        this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        for (int i = 0; i < counterexample.getNumVariables(); ++i) {
            Counterexample.Variable variable = counterexample.getVariable(i);
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(variable);
            this.treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
        }
    }

    private void addTermination(Termination termination, DefaultMutableTreeNode defaultMutableTreeNode) {
        VerificationAtomCollection verificationAtomCollection = termination.getDecreasing();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(verificationAtomCollection);
        this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        this.addVerificationAtomCollection(verificationAtomCollection, defaultMutableTreeNode2);
        VerificationAtomCollection verificationAtomCollection2 = termination.getNonnegative();
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(verificationAtomCollection2);
        this.treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        this.addVerificationAtomCollection(verificationAtomCollection2, defaultMutableTreeNode3);
    }

    private void expandPreviouslyExpandedNodes() {
        this.isExpandingNewlyAddedObjects = true;
        TreeSet<TreePath> treeSet = new TreeSet<TreePath>((SortedSet<TreePath>)this.viewableObjects);
        this.viewableObjects.clear();
        this.recExpandPreviouslyExpandedNodes(this.root, treeSet);
        this.isExpandingNewlyAddedObjects = false;
    }

    private void recExpandPreviouslyExpandedNodes(DefaultMutableTreeNode defaultMutableTreeNode, TreeSet<TreePath> treeSet) {
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        if (treeSet.contains(treePath)) {
            this.tree.expandPath(treePath);
        }
        if (this.prevSelectedNode != null && piObjectComparator.compare(new TreePath(this.prevSelectedNode.getPath()), treePath) == 0) {
            this.prevSelectedNode = this.selectedNode;
            this.selectedNode = defaultMutableTreeNode;
            this.nodeSelected(defaultMutableTreeNode.getUserObject());
            this.piGui.nodeSelected(defaultMutableTreeNode.getUserObject());
            this.tree.getSelectionModel().addSelectionPath(treePath);
        }
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            this.recExpandPreviouslyExpandedNodes((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i), treeSet);
        }
    }

    private void nodeSelected(Object object) {
        Object object2;
        if (object instanceof Step) {
            object2 = (Step)object;
            this.piCode.highlight(((Step)object2).getLocation(), PiCode.yellowHP);
        } else if (object instanceof VerificationAtom) {
            object2 = (VerificationAtom)object;
            this.piCode.highlight(((VerificationAtom)object2).getLocations(), PiCode.yellowHP);
        } else if (object instanceof Function) {
            object2 = (Function)object;
            this.piCode.highlight(((Function)object2).getLocation(), PiCode.yellowHP);
        } else if (object instanceof Counterexample.Variable) {
            object2 = (Counterexample.Variable)object;
            if (((Counterexample.Variable)object2).getLocation() != null) {
                this.piCode.highlight(((Counterexample.Variable)object2).getLocation(), PiCode.yellowHP);
            }
        } else if (object instanceof String) {
            object2 = (String)object;
            if ("Steps".equals(object2)) {
                this.nodeSelected(((DefaultMutableTreeNode)this.selectedNode.getParent()).getUserObject());
            } else {
                this.piCode.removeAllHighlights();
            }
        } else {
            this.piCode.removeAllHighlights();
        }
        object2 = this.getCorrespondingVC();
        if (object2 == null) {
            this.piGui.getVCPane().setNothing();
        } else {
            this.piGui.getVCPane().setVC((VerificationCondition)object2);
        }
    }

    private VerificationCondition getCorrespondingVC() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.selectedNode;
        while (defaultMutableTreeNode != null) {
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof VerificationAtom) {
                return ((VerificationAtom)object).getVC();
            }
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        }
        return null;
    }

    public void reselectSelectedNode() {
        this.nodeSelected(this.selectedNode.getUserObject());
    }

    public Object getSelectedObject() {
        if (this.selectedNode == null) {
            return null;
        }
        return this.selectedNode.getUserObject();
    }

    public void clear() {
        this.root = null;
        this.treeModel.setRoot(this.root);
        this.prevSelectedNode = this.selectedNode;
        this.selectedNode = null;
    }

    public void openedNewFile() {
        this.clear();
        this.viewableObjects.clear();
    }

    public void increaseFont() {
        this.tree.setFont(new Font("Droid Sans", 0, this.tree.getFont().getSize() + 2));
    }

    public void decreaseFont() {
        if (this.tree.getFont().getSize() > 10) {
            this.tree.setFont(new Font("Droid Sans", 0, this.tree.getFont().getSize() - 2));
        }
    }

    private static class PiObjectComparator
    implements Comparator<TreePath> {
        private PiObjectComparator() {
        }

        @Override
        public int compare(TreePath treePath, TreePath treePath2) {
            Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
            Object object2 = ((DefaultMutableTreeNode)treePath2.getLastPathComponent()).getUserObject();
            return this.compare(object, object2, treePath, treePath2);
        }

        public int compare(Object object, Object object2, TreePath treePath, TreePath treePath2) {
            String string;
            String string2 = object.getClass().getCanonicalName();
            if (string2.equals(string = object2.getClass().getCanonicalName())) {
                if (object instanceof VerificationResult) {
                    return ((VerificationResult)object).getFilename().compareTo(((VerificationResult)object2).getFilename());
                }
                if (object instanceof Function) {
                    return ((Function)object).getName().compareTo(((Function)object2).getName());
                }
                if (object instanceof VerificationAtomCollection) {
                    Function function = (Function)this.getLastObject(this.getParentPathFunction(treePath));
                    Function function2 = (Function)this.getLastObject(this.getParentPathFunction(treePath2));
                    String string3 = function.getName() + "." + ((VerificationAtomCollection)object).getLabel();
                    String string4 = function2.getName() + "." + ((VerificationAtomCollection)object2).getLabel();
                    return string3.compareTo(string4);
                }
                if (object instanceof Termination) {
                    TreePath treePath3 = this.getParentPathFunction(treePath);
                    TreePath treePath4 = this.getParentPathFunction(treePath2);
                    return this.compare(this.getLastObject(treePath3), this.getLastObject(treePath4), treePath3, treePath4);
                }
                if (object instanceof VerificationAtom) {
                    int n = ((VerificationAtom)object).getIdentifier().compareTo(((VerificationAtom)object2).getIdentifier());
                    if (n != 0) {
                        return n;
                    }
                    VerificationAtomCollection verificationAtomCollection = (VerificationAtomCollection)((DefaultMutableTreeNode)treePath.getParentPath().getLastPathComponent()).getUserObject();
                    VerificationAtomCollection verificationAtomCollection2 = (VerificationAtomCollection)((DefaultMutableTreeNode)treePath2.getParentPath().getLastPathComponent()).getUserObject();
                    return verificationAtomCollection.getLabel().compareTo(verificationAtomCollection2.getLabel());
                }
                if (object instanceof Step) {
                    TreePath treePath5 = this.getParentPathVerificationAtom(treePath);
                    TreePath treePath6 = this.getParentPathVerificationAtom(treePath2);
                    int n = this.compare(this.getLastObject(treePath5), this.getLastObject(treePath6), treePath5, treePath6);
                    if (n != 0) {
                        return n;
                    }
                    return ((Step)object).getText().compareTo(((Step)object2).getText());
                }
                if (object instanceof Counterexample.Variable) {
                    int n = ((Counterexample.Variable)object).getText().compareTo(((Counterexample.Variable)object2).getText());
                    if (n != 0) {
                        return n;
                    }
                    return this.compare(treePath.getParentPath(), treePath2.getParentPath());
                }
                if (object instanceof String) {
                    int n = ((String)object).compareTo((String)object2);
                    if (n != 0) {
                        return n;
                    }
                    return this.compare(treePath.getParentPath(), treePath2.getParentPath());
                }
                throw new RuntimeException("Invalid object in the tree.");
            }
            return string2.compareTo(string);
        }

        private TreePath getParentPathFunction(TreePath treePath) {
            if (treePath == null) {
                throw new RuntimeException("This path has no parent function.");
            }
            Object object = this.getLastObject(treePath);
            if (object instanceof Function) {
                return treePath;
            }
            return this.getParentPathFunction(treePath.getParentPath());
        }

        private TreePath getParentPathVerificationAtom(TreePath treePath) {
            if (treePath == null) {
                throw new RuntimeException("This path has no parent verification atom.");
            }
            Object object = this.getLastObject(treePath);
            if (object instanceof VerificationAtom) {
                return treePath;
            }
            return this.getParentPathVerificationAtom(treePath.getParentPath());
        }

        private Object getLastObject(TreePath treePath) {
            return ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
        }
    }

    private class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon valid = new ImageIcon(Utils.getURL("images/valid.jpg"));
        private ImageIcon invalid = new ImageIcon(Utils.getURL("images/invalid.jpg"));
        private ImageIcon unknown = new ImageIcon(Utils.getURL("images/unknown.jpg"));
        private ImageIcon timeout = new ImageIcon(Utils.getURL("images/timeout.jpg"));

        @Override
        public Color getBackgroundNonSelectionColor() {
            return null;
        }

        @Override
        public Color getBackground() {
            return null;
        }

        private ImageIcon getProperIcon(VerificationResult.validityT validityT2) {
            if (validityT2 == VerificationResult.validityT.VALID) {
                return this.valid;
            }
            if (validityT2 == VerificationResult.validityT.INVALID) {
                return this.invalid;
            }
            if (validityT2 == VerificationResult.validityT.UNKNOWN) {
                return this.unknown;
            }
            if (validityT2 == VerificationResult.validityT.TIMEOUT) {
                return this.timeout;
            }
            throw new RuntimeException("Unrecognized validity");
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof VerificationResult) {
                VerificationResult verificationResult = (VerificationResult)object2;
                this.setIcon(this.getProperIcon(verificationResult.getValidity()));
                String string = verificationResult.getFilename() != "" ? verificationResult.getFilename() : "Program";
                this.setText(string);
            } else if (object2 instanceof Function) {
                Function function = (Function)object2;
                this.setIcon(this.getProperIcon(function.getValidity()));
                this.setText(function.getName());
            } else if (object2 instanceof VerificationAtomCollection) {
                VerificationAtomCollection verificationAtomCollection = (VerificationAtomCollection)object2;
                this.setIcon(this.getProperIcon(verificationAtomCollection.getValidity()));
                this.setText(verificationAtomCollection.getLabel());
            } else if (object2 instanceof Termination) {
                Termination termination = (Termination)object2;
                this.setIcon(this.getProperIcon(termination.getValidity()));
                this.setText("Termination");
            } else if (object2 instanceof VerificationAtom) {
                VerificationAtom verificationAtom = (VerificationAtom)object2;
                this.setIcon(this.getProperIcon(verificationAtom.getValidity()));
                String string = verificationAtom.getIdentifier().replace("\\u2192", "\u2192");
                this.setText(string);
            } else if (object2 instanceof Step) {
                Step step = (Step)object2;
                this.setIcon(null);
                this.setText(step.getText());
            } else if (object2 instanceof Counterexample.Variable) {
                Counterexample.Variable variable = (Counterexample.Variable)object2;
                this.setIcon(null);
                this.setText(variable.getText());
            } else if (object2 instanceof String) {
                this.setIcon(null);
                this.setText((String)object2);
            }
            return this;
        }
    }
}

