/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class PiSubmit
extends PiDialog {
    private static final Dimension FIELD_SIZE = new Dimension(250, 28);
    private static final Dimension LABEL_SIZE_WITHOUT_SUBMIT_TO = new Dimension(130, 28);
    private static final Dimension LABEL_SIZE_WITH_SUBMIT_TO = new Dimension(190, 28);
    JTextField submitToField = null;
    JTextField userNameField;
    JTextField userEmailField;
    JTextPane comments;
    PiGui gui;

    public PiSubmit(PiGui piGui) {
        super(piGui, "Submit Program");
        JComponent jComponent;
        this.gui = piGui;
        Dimension dimension = Config.environmentKeyExists("submit_to_email_address") ? LABEL_SIZE_WITHOUT_SUBMIT_TO : LABEL_SIZE_WITH_SUBMIT_TO;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Your Information"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        JLabel jLabel = new JLabel("Name: ");
        jLabel.setPreferredSize(dimension);
        this.userNameField = new JTextField(Config.getValue("name"));
        this.userNameField.setPreferredSize(FIELD_SIZE);
        jPanel3.add(jLabel);
        jPanel3.add(this.userNameField);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        JLabel jLabel2 = new JLabel("Email address: ");
        jLabel2.setPreferredSize(dimension);
        this.userEmailField = new JTextField(Config.getValue("email_address"));
        this.userEmailField.setPreferredSize(FIELD_SIZE);
        jPanel4.add(jLabel2);
        jPanel4.add(this.userEmailField);
        JLabel jLabel3 = new JLabel("A confirmation of your submission will be emailed to you.");
        jLabel3.setAlignmentX(0.5f);
        jLabel3.setPreferredSize(new Dimension(380, 22));
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel2.add(jLabel3);
        JPanel jPanel5 = null;
        if (!Config.environmentKeyExists("submit_to_email_address")) {
            jPanel5 = new JPanel();
            jPanel5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Submission Information"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            jPanel5.setLayout(new BoxLayout(jPanel5, 0));
            jComponent = new JLabel("Email address to submit to: ");
            jComponent.setPreferredSize(dimension);
            this.submitToField = new JTextField(Config.getValue("submit_to_email_address"));
            this.submitToField.setPreferredSize(FIELD_SIZE);
            jPanel5.add(jComponent);
            jPanel5.add(this.submitToField);
        }
        this.comments = new JTextPane();
        this.comments.setPreferredSize(new Dimension(300, 100));
        this.comments.setBackground(Color.WHITE);
        jComponent = new JScrollPane(this.comments);
        jComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Comments (optional)"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(2));
        JButton jButton = new JButton("Submit");
        JButton jButton2 = this.getCancelButton();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PiSubmit.this.goSubmit();
            }
        });
        jPanel6.add(jButton);
        jPanel6.add(jButton2);
        JLabel jLabel4 = new JLabel("The submission procedure will also compile the program.");
        JLabel jLabel5 = new JLabel("Please be patient while this occurs.");
        jLabel4.setAlignmentX(0.5f);
        jLabel5.setAlignmentX(0.5f);
        jPanel.add(jPanel2);
        if (!Config.environmentKeyExists("submit_to_email_address")) {
            jPanel.add(jPanel5);
        }
        jPanel.add(jComponent);
        jPanel.add(jLabel4);
        jPanel.add(jLabel5);
        jPanel.add(jPanel6);
        this.add(jPanel);
        this.launch();
    }

    private void goSubmit() {
        if (!Utils.nameFieldIsWellFormatted(this.userNameField.getText())) {
            JOptionPane.showMessageDialog(this, "The 'Name' appears malformatted.", "Error", 0);
            return;
        }
        if (!Utils.emailAddressIsWellFormatted(this.userEmailField.getText())) {
            JOptionPane.showMessageDialog(this, "The 'Email address' appears malformatted.", "Error", 0);
            return;
        }
        if (this.submitToField != null && !Utils.emailAddressIsWellFormatted(this.submitToField.getText())) {
            JOptionPane.showMessageDialog(this, "The email address to submit to appears malformatted.", "Error", 0);
            return;
        }
        Config.setValue("name", this.userNameField.getText());
        Config.setValue("email_address", this.userEmailField.getText());
        if (this.submitToField != null) {
            Config.setValue("submit_to_email_address", this.submitToField.getText());
        }
        this.close();
        String string = null;
        if (this.comments.getText().length() > 0) {
            string = this.comments.getText();
        }
        this.gui.doCompileAndMaybeSubmit(true, string);
    }
}

