/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class PiReport
extends PiDialog {
    private static final Dimension FIELD_SIZE = new Dimension(250, 28);
    private static final Dimension LABEL_SIZE = new Dimension(130, 28);
    private static final Dimension COMMENTS_SIZE = new Dimension(400, 150);
    JTextField userNameField;
    JTextField userEmailField;
    JTextPane comments;
    ReportType type;
    PiGui gui;
    JCheckBox includeSource;

    private static String getWindowTitle(ReportType reportType) {
        if (reportType == ReportType.bug) {
            return "Report a Bug";
        }
        return "Give Feedback About PiVC";
    }

    private String getCommentsLabel() {
        if (this.type == ReportType.bug) {
            return "Description of Problem";
        }
        return "Feedback";
    }

    private String getSubmitText() {
        if (this.type == ReportType.bug) {
            return "Send Bug Report";
        }
        return "Send Feedback";
    }

    public PiReport(PiGui piGui, ReportType reportType) {
        super(piGui, PiReport.getWindowTitle(reportType));
        JPanel jPanel;
        this.gui = piGui;
        this.type = reportType;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Your Information (optional)"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        JLabel jLabel = new JLabel("Name: ");
        jLabel.setPreferredSize(LABEL_SIZE);
        this.userNameField = new JTextField(Config.getValue("name"));
        this.userNameField.setPreferredSize(FIELD_SIZE);
        jPanel4.add(jLabel);
        jPanel4.add(this.userNameField);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        JLabel jLabel2 = new JLabel("Email address: ");
        jLabel2.setPreferredSize(LABEL_SIZE);
        this.userEmailField = new JTextField(Config.getValue("email_address"));
        this.userEmailField.setPreferredSize(FIELD_SIZE);
        jPanel5.add(jLabel2);
        jPanel5.add(this.userEmailField);
        jPanel3.add(jPanel4);
        jPanel3.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.getCommentsLabel()), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.comments = new JTextPane();
        this.comments.setBackground(Color.WHITE);
        JScrollPane jScrollPane = new JScrollPane(this.comments);
        jPanel6.add(jScrollPane);
        this.comments.setPreferredSize(COMMENTS_SIZE);
        if (reportType == ReportType.bug) {
            this.includeSource = new JCheckBox("Include currently open file with bug report", true);
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(this.includeSource);
            jPanel6.add(jPanel);
        }
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(this.getSubmitText());
        JButton jButton2 = this.getCancelButton();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PiReport.this.goSubmit();
            }
        });
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel6);
        jPanel2.add(jPanel);
        this.add(jPanel2);
        this.launch();
    }

    private void goSubmit() {
        if (this.userNameField.getText().length() > 0 && !Utils.nameFieldIsWellFormatted(this.userNameField.getText())) {
            JOptionPane.showMessageDialog(this, "The 'Name' appears malformatted.", "Error", 0);
            return;
        }
        if (this.userEmailField.getText().length() > 0 && !Utils.emailAddressIsWellFormatted(this.userEmailField.getText())) {
            JOptionPane.showMessageDialog(this, "The 'Email address' appears malformatted.", "Error", 0);
            return;
        }
        Config.setValue("name", this.userNameField.getText());
        Config.setValue("email_address", this.userEmailField.getText());
        this.close();
        String string = null;
        if (this.comments.getText().length() > 0) {
            string = this.comments.getText();
        }
        this.gui.doReport(this.type, string, this.includeSource != null && this.includeSource.isSelected());
    }

    public static String stringOfReportType(ReportType reportType) {
        if (reportType == ReportType.bug) {
            return "bug";
        }
        return "feedback";
    }

    public static enum ReportType {
        bug,
        feedback;

    }
}

