/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.undo.UndoManager;

public class PiMenu
extends JMenuBar
implements DirtyChangedListener {
    private PiGui piGui;
    private JMenuItem save;
    private JMenuItem undo;
    private JMenuItem redo;
    private JMenuItem cut;
    private JMenuItem copy;
    private JMenuItem paste;
    private JMenuItem displayPath;
    private JMenuItem submit;
    private JMenuItem compileMenuItem;
    private JMenuItem cancelCompileMenuItem;
    private JMenuItem increaseFont;
    private JMenuItem decreaseFont;
    private JCheckBoxMenuItem runtimeAssertions;
    private JCheckBoxMenuItem findInductiveCore;
    private JCheckBoxMenuItem autoSaveCompile;

    public PiMenu(PiGui piGui) {
        this.piGui = piGui;
        piGui.addDirtyChangedListener(this);
        this.addFileMenu();
        this.addEditMenu();
        this.addActionsMenu();
        this.addAnalyzeMenu();
        this.addSettingsMenu();
        this.addHelpMenu();
    }

    private void addFileMenu() {
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem("New");
        jMenuItem.setMnemonic(78);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PiMenu.this.piGui.newFile();
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Open");
        jMenuItem2.setMnemonic(79);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PiMenu.this.piGui.open();
            }
        });
        jMenu.add(jMenuItem2);
        this.save = new JMenuItem("Save");
        this.save.setMnemonic(83);
        this.save.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PiMenu.this.piGui.save();
            }
        });
        jMenu.add(this.save);
        JMenuItem jMenuItem3 = new JMenuItem("Save As...");
        jMenuItem3.setMnemonic(65);
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PiMenu.this.piGui.saveAs();
            }
        });
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Quit");
        jMenuItem4.setMnemonic(81);
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PiMenu.this.piGui.doExit();
            }
        });
        jMenu.add(jMenuItem4);
        this.add(jMenu);
    }

    private void addEditMenu() {
        JMenu jMenu = new JMenu("Edit");
        jMenu.setMnemonic(69);
        this.undo = new JMenuItem("Undo");
        this.undo.setMnemonic(85);
        this.undo.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.undo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PiMenu.this.piGui.undo();
            }
        });
        this.undo.setEnabled(false);
        jMenu.add(this.undo);
        this.redo = new JMenuItem("Redo");
        this.redo.setMnemonic(82);
        this.redo.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.redo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PiMenu.this.piGui.redo();
            }
        });
        this.redo.setEnabled(false);
        jMenu.add(this.redo);
        jMenu.addSeparator();
        this.cut = new JMenuItem("Cut");
        this.cut.setMnemonic(84);
        this.cut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PiMenu.this.piGui.cut();
            }
        });
        this.cut.setEnabled(false);
        jMenu.add(this.cut);
        this.copy = new JMenuItem("Copy");
        this.copy.setMnemonic(67);
        this.copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PiMenu.this.piGui.copy();
            }
        });
        this.copy.setEnabled(false);
        jMenu.add(this.copy);
        this.paste = new JMenuItem("Paste");
        this.paste.setMnemonic(80);
        this.paste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PiMenu.this.piGui.paste();
            }
        });
        jMenu.add(this.paste);
        this.add(jMenu);
    }

    private void addActionsMenu() {
        JMenu jMenu = new JMenu("Actions");
        jMenu.setMnemonic(65);
        this.compileMenuItem = new JMenuItem("Compile");
        this.compileMenuItem.setMnemonic(67);
        this.compileMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.compileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PiMenu.this.piGui.doCompile();
            }
        });
        jMenu.add(this.compileMenuItem);
        this.cancelCompileMenuItem = new JMenuItem("Abandon compile");
        this.cancelCompileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PiMenu.this.piGui.cancelCompile();
            }
        });
        this.cancelCompileMenuItem.setEnabled(false);
        jMenu.add(this.cancelCompileMenuItem);
        jMenu.addSeparator();
        this.submit = new JMenuItem("Submit");
        this.submit.setMnemonic(83);
        this.submit.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.submit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PiMenu.this.piGui.doSubmit();
            }
        });
        jMenu.add(this.submit);
        this.add(jMenu);
    }

    private void addAnalyzeMenu() {
        JMenu jMenu = new JMenu("Analyze");
        jMenu.setMnemonic(90);
        this.displayPath = new JMenuItem("Display selected basic path");
        this.displayPath.setMnemonic(68);
        this.displayPath.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.displayPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PiMenu.this.piGui.displaySelectedBasicPath();
            }
        });
        this.displayPath.setEnabled(false);
        jMenu.add(this.displayPath);
        this.add(jMenu);
    }

    private void addSettingsMenu() {
        JMenu jMenu = new JMenu("Settings");
        jMenu.setMnemonic(83);
        this.runtimeAssertions = new JCheckBoxMenuItem("Generate runtime assertions");
        this.runtimeAssertions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Config.setBooleanValue("generate_runtime_assertions", PiMenu.this.runtimeAssertions.getState());
            }
        });
        this.runtimeAssertions.setState(Config.getBooleanValue("generate_runtime_assertions"));
        jMenu.add(this.runtimeAssertions);
        this.findInductiveCore = new JCheckBoxMenuItem("Find inductive core");
        this.findInductiveCore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Config.setBooleanValue("find_inductive_core", PiMenu.this.findInductiveCore.getState());
            }
        });
        this.findInductiveCore.setState(Config.getBooleanValue("find_inductive_core"));
        jMenu.add(this.findInductiveCore);
        this.autoSaveCompile = new JCheckBoxMenuItem("Auto save on compile");
        this.autoSaveCompile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Config.setBooleanValue("auto_save_compile", PiMenu.this.autoSaveCompile.getState());
            }
        });
        this.autoSaveCompile.setState(Config.getBooleanValue("auto_save_compile"));
        jMenu.add(this.autoSaveCompile);
        jMenu.addSeparator();
        if (!Config.environmentKeyExists("server_address")) {
            JMenuItem jMenuItem = new JMenuItem("Change server address");
            jMenuItem.setMnemonic(83);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)JOptionPane.showInputDialog(PiMenu.this.piGui, "Enter the address in the form 'host:port'.", "Change server address", 3, null, null, Config.getValue("server_address"));
                    if (string != null) {
                        Config.setValue("server_address", string);
                    }
                }
            });
            jMenu.add(jMenuItem);
        }
        jMenu.addSeparator();
        this.increaseFont = new JMenuItem("Increase font size");
        this.increaseFont.setMnemonic(73);
        this.increaseFont.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        this.increaseFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PiMenu.this.piGui.doIncreaseFont();
            }
        });
        jMenu.add(this.increaseFont);
        this.decreaseFont = new JMenuItem("Decrease font size");
        this.decreaseFont.setMnemonic(75);
        this.decreaseFont.setAccelerator(KeyStroke.getKeyStroke(75, 2));
        this.decreaseFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PiMenu.this.piGui.doDecreaseFont();
            }
        });
        jMenu.add(this.decreaseFont);
        this.add(jMenu);
    }

    private void addHelpMenu() {
        JMenu jMenu = new JMenu("Help");
        jMenu.setMnemonic(72);
        JMenuItem jMenuItem = new JMenuItem("Report a Bug");
        jMenuItem.setMnemonic(82);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PiMenu.this.piGui.doReport(PiReport.ReportType.bug);
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Give Feedback on PiVC");
        jMenuItem2.setMnemonic(70);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PiMenu.this.piGui.doReport(PiReport.ReportType.feedback);
            }
        });
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem("About PiVC");
        jMenuItem3.setMnemonic(65);
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = "<html>PiVC Client<br>Version 1.01<br><br>Jason Auerbach, Aaron Bradley,<br>Joel Galenson, Zohar Manna<br><br>Licensed under the GPL.</html>";
                JOptionPane.showMessageDialog(PiMenu.this.piGui, string, "About PiVC", 1, PiGui.getIcon());
            }
        });
        jMenu.add(jMenuItem3);
        this.add(jMenu);
    }

    public void undoChangeHappened(UndoManager undoManager) {
        this.undo.setEnabled(undoManager.canUndo());
        if (undoManager.canUndo()) {
            this.undo.setText(undoManager.getUndoPresentationName());
        } else {
            this.undo.setText("Undo");
        }
        this.redo.setEnabled(undoManager.canRedo());
        if (undoManager.canRedo()) {
            this.redo.setText(undoManager.getRedoPresentationName());
        } else {
            this.redo.setText("Redo");
        }
    }

    public void enableBasicPathHighlighter(boolean bl) {
        this.displayPath.setEnabled(bl);
    }

    @Override
    public void dirtyChanged(boolean bl) {
        this.save.setEnabled(bl);
    }

    public void isCompiling(boolean bl) {
        this.compileMenuItem.setEnabled(!bl);
        this.cancelCompileMenuItem.setEnabled(bl);
    }

    public void codeIsSelected(boolean bl) {
        this.cut.setEnabled(bl);
        this.copy.setEnabled(bl);
    }
}

