/*
 * Decompiled with CFR 0.152.
 */
import data_structures.BasicPath;
import data_structures.PiError;
import data_structures.Step;
import data_structures.VerificationAtom;
import data_structures.VerificationResult;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.Socket;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.undo.UndoManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PiGui
extends JFrame {
    private static final int DEFAULT_WIDTH = 800;
    private static final int DEFAULT_HEIGHT = 800;
    private static final String TITLE = "PiVC";
    private PiCode piCode;
    private PiErrorOutput piErrorOutput;
    private PiCompilerOutput piCompilerOutput;
    private PiTree piTree;
    private PiMenu piMenu;
    private JTabbedPane rightTabbedPane;
    private ServerResponseParser serverResponseParser;
    private JFileChooser fileChooser;
    private File curFile;
    private boolean dirty;
    private ArrayList<DirtyChangedListener> dirtyChangedListeners;
    private JButton compileButton;
    private JButton submitButton;
    private JButton increaseFont;
    private JButton decreaseFont;
    private JLabel statusBarLabel;
    private JProgressBar statusProgressBar;
    private Compiler curCompilation;
    private PiVCPane vcPane;
    private static ImageIcon icon = new ImageIcon(Utils.getURL("images/Pi-symbol.png"));

    public PiGui() {
        super(TITLE);
        this.runGui(null);
    }

    public PiGui(String string) {
        super(TITLE);
        this.runGui(string);
    }

    private void runGui(String string) {
        this.setLayout(new BorderLayout());
        this.useSystemLookAndFeel();
        this.setIconImage(icon.getImage());
        this.initDataPre();
        this.installMain();
        this.installMenu();
        this.installTop();
        this.installStatusBar();
        this.initDataPost();
        this.setupWindow();
        if (string != null) {
            this.curFile = new File(string);
            this.loadFile(this.curFile);
            this.filenameChanged();
        }
    }

    public static void main(final String[] stringArray) {
        Config.initConfig();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (stringArray.length == 0) {
                    new PiGui();
                } else {
                    for (int i = 0; i < stringArray.length; ++i) {
                        new PiGui(stringArray[i]);
                    }
                }
            }
        });
    }

    public void open() {
        if (!this.saveAndConfirmIfDirty()) {
            return;
        }
        if (this.fileChooser.showOpenDialog(this) == 0) {
            this.curFile = this.fileChooser.getSelectedFile();
            this.setDefaultPiFilesLocation(this.curFile);
            this.loadFile(this.curFile);
            this.filenameChanged();
        }
    }

    public void save() {
        if (this.curFile == null) {
            this.saveAs();
        } else {
            this.saveFile(this.curFile);
        }
    }

    public void saveAs() {
        if (this.fileChooser.showSaveDialog(this) == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.setDefaultPiFilesLocation(file);
            this.saveFile(file);
        }
    }

    private void setDefaultPiFilesLocation(File file) {
        String string = null;
        try {
            string = file.getParentFile().getCanonicalPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Config.setValue("pi_files_location", string);
    }

    public void doExit() {
        if (!this.saveAndConfirmIfDirty()) {
            return;
        }
        this.dispose();
        System.exit(0);
    }

    public void loadFile(File file) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            this.piCode.read(bufferedReader, null);
            this.piCode.openedNewFile();
            this.piTree.openedNewFile();
            this.piErrorOutput.clear();
            this.vcPane.clear();
            if (this.curCompilation != null) {
                this.cancelCompile();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void saveFile(File file) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(this.piCode.getText());
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        this.curFile = file;
        this.filenameChanged();
    }

    public void newFile() {
        if (!this.saveAndConfirmIfDirty()) {
            return;
        }
        this.piCode.clear();
        this.piCode.openedNewFile();
        this.piTree.openedNewFile();
        this.piErrorOutput.clear();
        this.vcPane.clear();
        this.initFileChooser();
        this.curFile = null;
        this.filenameChanged();
    }

    private boolean saveAndConfirmIfDirty() {
        if (this.dirty) {
            return this.askToSave();
        }
        return true;
    }

    private void filenameChanged() {
        this.setDirty(false);
        String string = this.getCurFilename();
        String string2 = string != "" ? " - " + string : "";
        this.setTitle(TITLE + string2);
        this.setStatusBarLabel();
    }

    private boolean askToSave() {
        int n = JOptionPane.showConfirmDialog(this, "Save changes first?", "Save?", 1);
        if (n == 0) {
            this.save();
        }
        return n != 2;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
        this.fireDirtyChanged();
    }

    public void doCompile() {
        this.doCompileAndMaybeSubmit(false, null);
    }

    public void doCompileAndMaybeSubmit(boolean bl, String string) {
        String string2 = this.piCode.getText();
        boolean bl2 = Config.getBooleanValue("generate_runtime_assertions");
        boolean bl3 = Config.getBooleanValue("find_inductive_core");
        this.curCompilation = new Compiler(string2, bl2, bl3, bl, string, this);
        this.compileStarted();
        this.curCompilation.start();
    }

    public void doSubmit() {
        new PiSubmit(this);
    }

    public void doIncreaseFont() {
        this.piCode.increaseFont();
        this.piTree.increaseFont();
        this.vcPane.increaseFont();
        this.piErrorOutput.increaseFont();
    }

    public void doDecreaseFont() {
        this.piCode.decreaseFont();
        this.piTree.decreaseFont();
        this.vcPane.decreaseFont();
        this.piErrorOutput.decreaseFont();
    }

    public void doReport(PiReport.ReportType reportType) {
        new PiReport(this, reportType);
    }

    public void doReport(PiReport.ReportType reportType, String string, boolean bl) {
        String string2 = null;
        if (bl) {
            string2 = this.piCode.getText();
        }
        this.curCompilation = new Compiler(reportType, string2, string, this);
        this.compileStarted();
        this.curCompilation.start();
    }

    private void compileStarted() {
        assert (this.curCompilation != null);
        this.piCode.removeAllHighlights();
        this.compileButton.setEnabled(false);
        this.piMenu.isCompiling(true);
        this.setStatusBarLabel();
        this.statusProgressBar.setIndeterminate(true);
        this.statusProgressBar.setVisible(true);
    }

    private String getCurFilename() {
        return this.curFile == null ? "" : " " + this.curFile.getName();
    }

    private void setStatusBarLabel() {
        String string = this.getCurFilename();
        if (this.curCompilation != null) {
            this.statusBarLabel.setText("Compiling" + string);
        } else {
            this.statusBarLabel.setText("Editing" + string);
        }
    }

    private void handleServerResponse(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PiGui.this.piCompilerOutput.setText(string);
                String[] stringArray = PiGui.this.serverResponseParser.parse(string, PiGui.this.getCurFilename());
                PiGui.this.rightTabbedPane.repaint();
                PiGui.this.compileEnded();
                if (stringArray != null) {
                    for (String string2 : stringArray) {
                        JOptionPane.showMessageDialog(PiGui.this, string2, "Message", 1);
                    }
                }
            }
        });
    }

    private void compileEnded() {
        this.curCompilation = null;
        this.compileButton.setEnabled(true);
        this.piMenu.isCompiling(false);
        this.setStatusBarLabel();
        this.statusProgressBar.setIndeterminate(false);
        this.statusProgressBar.setVisible(false);
    }

    public void cancelCompile() {
        if (this.curCompilation != null) {
            this.curCompilation.interrupt();
        }
        this.compileEnded();
    }

    public void handleVerificationResult(VerificationResult verificationResult) {
        this.piErrorOutput.clear();
        this.vcPane.setNothing();
        this.piTree.handleVerificationResult(verificationResult);
        this.rightTabbedPane.setSelectedIndex(0);
    }

    public void handleError(ArrayList<PiError> arrayList) {
        this.piTree.clear();
        this.vcPane.clear();
        this.piErrorOutput.setErrors(arrayList);
        this.rightTabbedPane.setSelectedIndex(1);
    }

    public void handleCompilerError(PiError piError) {
        this.piTree.clear();
        this.vcPane.clear();
        this.piErrorOutput.setCompilerError(piError);
        this.rightTabbedPane.setSelectedIndex(1);
    }

    public void undoChangeHappened(UndoManager undoManager) {
        this.piMenu.undoChangeHappened(undoManager);
    }

    public void undo() {
        boolean bl = this.piCode.undo();
        if (!bl) {
            this.setDirty(false);
        }
    }

    public void redo() {
        this.piCode.redo();
    }

    public void cut() {
        this.piCode.cut();
    }

    public void copy() {
        this.piCode.copy();
    }

    public void paste() {
        this.piCode.paste();
    }

    public void codeIsSelected(boolean bl) {
        this.piMenu.codeIsSelected(bl);
    }

    public PiVCPane getVCPane() {
        return this.vcPane;
    }

    public void nodeSelected(Object object) {
        this.piMenu.enableBasicPathHighlighter(object instanceof VerificationAtom && ((VerificationAtom)object).getBP() != null);
    }

    public void displaySelectedBasicPath() {
        VerificationAtom verificationAtom = (VerificationAtom)this.piTree.getSelectedObject();
        BasicPath basicPath = verificationAtom.getBP();
        if (basicPath != null) {
            BasicPathHighlighter basicPathHighlighter = new BasicPathHighlighter(basicPath);
            basicPathHighlighter.start();
        }
    }

    public void showHideRawXml(boolean bl) {
        Config.setBooleanValue("show_raw_xml", bl);
        if (bl) {
            this.rightTabbedPane.addTab("Raw XML", new JScrollPane(this.piCompilerOutput));
            this.rightTabbedPane.setMnemonicAt(2, 82);
        } else if (this.rightTabbedPane.getTabCount() >= 3) {
            this.rightTabbedPane.removeTabAt(2);
        }
    }

    public static Icon getIcon() {
        return icon;
    }

    private void initDataPre() {
        this.serverResponseParser = new ServerResponseParser(this);
        this.initFileChooser();
        this.curFile = null;
        this.dirtyChangedListeners = new ArrayList();
        this.curCompilation = null;
    }

    private void initDataPost() {
        this.setDirty(false);
    }

    private void initFileChooser() {
        try {
            this.fileChooser = new JFileChooser(new File(Config.getValue("pi_files_location")).getCanonicalPath());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.fileChooser.addChoosableFileFilter(new PiFileFilter());
    }

    private void installMain() {
        JPanel jPanel = new JPanel();
        this.piCode = new PiCode(this);
        this.piCode.setPreferredSize(new Dimension(400, 800));
        jPanel.setLayout(new GridLayout(1, 1));
        jPanel.add(this.piCode);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Code"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.rightTabbedPane = new JTabbedPane();
        this.rightTabbedPane.setPreferredSize(new Dimension(400, 800));
        this.piTree = new PiTree(this, this.piCode);
        this.vcPane = new PiVCPane(this.piCode);
        JScrollPane jScrollPane = this.vcPane.getPiVCPaneInScrollPane();
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Verification Condition"));
        JSplitPane jSplitPane = new JSplitPane(0, this.piTree.getTreeInScrollPane(), jScrollPane);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setDividerLocation(600);
        this.piErrorOutput = new PiErrorOutput(this.piCode);
        this.piCompilerOutput = new PiCompilerOutput();
        this.rightTabbedPane.addTab("Verify", jSplitPane);
        this.rightTabbedPane.setMnemonicAt(0, 86);
        this.rightTabbedPane.addTab("Compilation Errors", this.piErrorOutput.getErrorOutputInScrollPane());
        this.rightTabbedPane.setMnemonicAt(1, 69);
        this.showHideRawXml(Config.getBooleanValue("show_raw_xml"));
        this.rightTabbedPane.setPreferredSize(new Dimension(400, 600));
        JSplitPane jSplitPane2 = new JSplitPane(1, jPanel, this.rightTabbedPane);
        jSplitPane2.setOneTouchExpandable(true);
        jSplitPane2.setContinuousLayout(true);
        this.add(jSplitPane2);
    }

    private void installMenu() {
        this.piMenu = new PiMenu(this);
        this.setJMenuBar(this.piMenu);
    }

    private void installTop() {
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(10));
        this.compileButton = new JButton("Compile");
        this.compileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Config.getBooleanValue("auto_save_compile")) {
                    PiGui.this.save();
                }
                PiGui.this.doCompile();
            }
        });
        box.add(this.compileButton);
        box.add(Box.createHorizontalStrut(20));
        this.submitButton = new JButton("Submit");
        this.submitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PiGui.this.doSubmit();
            }
        });
        box.add(this.submitButton);
        box.add(Box.createHorizontalStrut(20));
        this.add((Component)box, "North");
    }

    private void installStatusBar() {
        Box box = Box.createHorizontalBox();
        box.setPreferredSize(new Dimension(100, 20));
        box.add(Box.createHorizontalStrut(10));
        this.statusBarLabel = new JLabel("Editing");
        box.add(this.statusBarLabel);
        box.add(Box.createHorizontalGlue());
        box.add(Box.createHorizontalStrut(300));
        this.statusProgressBar = new JProgressBar();
        this.statusProgressBar.setVisible(false);
        box.add(this.statusProgressBar);
        box.add(Box.createHorizontalStrut(10));
        this.add((Component)box, "South");
    }

    private void setupWindow() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PiGui.this.doExit();
            }
        });
        this.pack();
        this.setVisible(true);
        this.piCode.requestFocus();
    }

    private void useSystemLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addDirtyChangedListener(DirtyChangedListener dirtyChangedListener) {
        this.dirtyChangedListeners.add(dirtyChangedListener);
    }

    private void fireDirtyChanged() {
        for (DirtyChangedListener dirtyChangedListener : this.dirtyChangedListeners) {
            dirtyChangedListener.dirtyChanged(this.dirty);
        }
    }

    private class BasicPathHighlighter
    extends Thread {
        private static final int TOTAL_BASIC_PATH_HIGHLIGHT_TIME = 500;
        private BasicPath basicPath;

        public BasicPathHighlighter(BasicPath basicPath) {
            this.basicPath = basicPath;
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PiGui.this.piCode.removeAllHighlights();
                }
            });
            long l = 500L / (long)this.basicPath.getNumSteps();
            for (int i = 0; i < this.basicPath.getNumSteps(); ++i) {
                final Step step = this.basicPath.getStep(i);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PiGui.this.piCode.highlight(step.getLocation(), PiCode.yellowHP);
                    }
                });
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PiGui.this.piCode.removeAllHighlights();
                    }
                });
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PiGui.this.piTree.reselectSelectedNode();
                }
            });
        }
    }

    private static class PiFileFilter
    extends FileFilter {
        private PiFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            if (string.length() < 3) {
                return true;
            }
            String string2 = string.substring(string.length() - 2).toLowerCase();
            return string2 != null && string2.equals("pi");
        }

        @Override
        public String getDescription() {
            return "Pi programs";
        }
    }

    private class Compiler
    extends Thread {
        private String code;
        private boolean shouldGenerateRuntimeAssertions;
        private boolean shouldFindInductiveCore;
        private PiGui gui;
        private boolean alsoSubmit;
        private String submissionComment;
        private boolean isReport;
        private PiReport.ReportType reportType;
        private String reportComment;

        public Compiler(String string, boolean bl, boolean bl2, boolean bl3, String string2, PiGui piGui2) {
            this.code = string;
            this.shouldGenerateRuntimeAssertions = bl;
            this.shouldFindInductiveCore = bl2;
            this.alsoSubmit = bl3;
            this.submissionComment = string2;
            this.gui = piGui2;
            this.isReport = false;
        }

        public Compiler(PiReport.ReportType reportType, String string, String string2, PiGui piGui2) {
            this.code = string;
            this.reportComment = string2;
            this.reportType = reportType;
            this.isReport = true;
            this.alsoSubmit = false;
        }

        @Override
        public void run() {
            final String string = Config.getValueWithEnvironmentOverride("server_address");
            if (string != null) {
                String[] stringArray = string.split(":");
                String string2 = stringArray[0].trim();
                int n = Integer.parseInt(stringArray[1].trim());
                try {
                    Socket socket = new Socket(string2, n);
                    DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
                    String string3 = this.createXmlString();
                    dataOutputStream.writeInt(string3.length());
                    dataOutputStream.writeBytes(string3);
                    dataOutputStream.flush();
                    DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
                    int n2 = dataInputStream.readInt();
                    byte[] byArray = new byte[n2];
                    dataInputStream.readFully(byArray, 0, n2);
                    String string4 = new String(byArray);
                    PiGui.this.handleServerResponse(string4);
                }
                catch (ConnectException connectException) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PiGui.this.compileEnded();
                            String string2 = "You attempted to connect to " + string + ". Ensure that a piVC server is running\nand that the server address in the Settings menu is set to the proper address.";
                            if (Config.environmentKeyExists("server_address")) {
                                string2 = "You attempted to connect to " + string + ". Ensure that a piVC server is running at this address.";
                            }
                            JOptionPane.showMessageDialog(Compiler.this.gui, connectException.getMessage() + "\n\n" + string2, "Connection Error", 0);
                        }
                    });
                }
                catch (IOException iOException) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PiGui.this.compileEnded();
                            String string = "There has been an error in the connection with the server.";
                            JOptionPane.showMessageDialog(Compiler.this.gui, string + "\n\n" + iOException.toString(), "Connection Error", 0);
                        }
                    });
                    iOException.printStackTrace();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        private String createXmlString() {
            try {
                Object object;
                Object object2;
                Element element;
                Object object3;
                Object object4;
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                Element element2 = document.createElement("piVC_transmission");
                String string = null;
                string = this.isReport ? "report" : "program_submission_request";
                element2.setAttribute("type", string);
                document.appendChild(element2);
                if (this.code != null) {
                    this.code = this.code.replaceAll("\n", "\n\b");
                    object4 = document.createElement("code");
                    object4.setTextContent(this.code);
                    object4.setAttribute("xml:space", "preserve");
                    element2.appendChild((Node)object4);
                }
                if (this.isReport) {
                    object4 = PiReport.stringOfReportType(this.reportType);
                    object3 = document.createElement("report_type");
                    object3.setTextContent((String)object4);
                    element2.appendChild((Node)object3);
                }
                if (this.reportComment != null) {
                    object4 = document.createElement("comment");
                    object4.setTextContent(this.reportComment);
                    element2.appendChild((Node)object4);
                }
                object4 = Config.getValue("name");
                object3 = Config.getValue("email_address");
                if (((String)object4).length() > 0 || ((String)object3).length() > 0) {
                    element = document.createElement("user");
                    element.setAttribute("name", (String)object4);
                    element.setAttribute("email_addr", (String)object3);
                    element2.appendChild(element);
                }
                element = document.createElement("options");
                if (this.shouldGenerateRuntimeAssertions) {
                    object2 = document.createElement("generate_runtime_assertions");
                    element.appendChild((Node)object2);
                }
                if (this.shouldFindInductiveCore) {
                    object2 = document.createElement("find_inductive_core");
                    element.appendChild((Node)object2);
                }
                if (this.alsoSubmit) {
                    object2 = document.createElement("submit");
                    object = document.createElement("to_addrs");
                    String[] stringArray = Config.getValueWithEnvironmentOverride("submit_to_email_address").split(",");
                    for (String string2 : stringArray) {
                        Element element3 = document.createElement("addr");
                        element3.setTextContent(string2.trim());
                        object.appendChild(element3);
                    }
                    object2.appendChild((Node)object);
                    if (this.submissionComment != null) {
                        Element element4 = document.createElement("comment");
                        element4.setTextContent(this.submissionComment);
                        object2.appendChild(element4);
                    }
                    element.appendChild((Node)object2);
                }
                element2.appendChild(element);
                object2 = TransformerFactory.newInstance().newTransformer();
                ((Transformer)object2).setOutputProperty("omit-xml-declaration", "yes");
                ((Transformer)object2).setOutputProperty("indent", "yes");
                object = new StringWriter();
                ((Transformer)object2).transform(new DOMSource(document), new StreamResult((Writer)object));
                return ((StringWriter)object).toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(this.gui, exception.getMessage(), "XML building error error", 0);
                throw new RuntimeException("Xml building error: " + exception.getMessage());
            }
        }
    }
}

