/*
 * Decompiled with CFR 0.152.
 */
import data_structures.Location;
import data_structures.PiError;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PiErrorOutput
extends JPanel {
    private JList list;
    private DefaultListModel model;
    private PiCode piCode;
    private ListSelector selectionModel;

    public PiErrorOutput(PiCode piCode) {
        this.piCode = piCode;
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        this.selectionModel = new ListSelector();
        this.initList();
    }

    private void initList() {
        this.list.setCellRenderer(new MyListCellRenderer());
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                int n = PiErrorOutput.this.list.locationToIndex(mouseEvent.getPoint());
                if (n != -1 && PiErrorOutput.this.list.getCellBounds(n, n).contains(mouseEvent.getPoint())) {
                    PiErrorOutput.this.selectionModel.select(n);
                    PiErrorOutput.this.errorClicked(PiErrorOutput.this.list.getModel().getElementAt(n));
                } else {
                    PiErrorOutput.this.selectionModel.clearSelection();
                    PiErrorOutput.this.errorClicked(null);
                }
            }
        });
        this.list.setSelectionModel(this.selectionModel);
    }

    private void errorClicked(Object object) {
        if (object == null) {
            this.piCode.removeAllHighlights();
        } else {
            Location location = ((PiError)object).getLocation();
            if (location != null) {
                this.piCode.highlight(location, PiCode.redHP);
            }
        }
    }

    public JScrollPane getErrorOutputInScrollPane() {
        return new JScrollPane(this.list);
    }

    public void setErrors(ArrayList<PiError> arrayList) {
        this.clear();
        for (PiError piError : arrayList) {
            this.model.addElement(piError);
        }
    }

    public void setCompilerError(PiError piError) {
        this.clear();
        this.model.addElement(piError);
    }

    public void clear() {
        this.model.clear();
    }

    public void increaseFont() {
        this.list.setFont(new Font("Droid Sans", 0, this.list.getFont().getSize() + 2));
    }

    public void decreaseFont() {
        if (this.list.getFont().getSize() > 10) {
            this.list.setFont(new Font("Droid Sans", 0, this.list.getFont().getSize() - 2));
        }
    }

    private static class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.setText("<html>" + ((PiError)object).getMessage() + "</html>");
            return this;
        }
    }
}

