/*
 * Decompiled with CFR 0.152.
 */
import data_structures.Location;
import java.awt.Color;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import org.syntax.jedit.JEditTextArea;
import org.syntax.jedit.tokenmarker.PiTokenMarker;

public class PiCode
extends JEditTextArea
implements DocumentListener,
DirtyChangedListener {
    public static Color yellowHP = Color.YELLOW;
    public static Color redHP = Color.RED;
    private PiGui piGui;
    private boolean justLoaded;
    private UndoManager undo;

    public PiCode(PiGui piGui) {
        this.setTokenMarker(new PiTokenMarker());
        this.piGui = piGui;
        this.justLoaded = false;
        this.undo = new UndoManager();
        this.piGui.addDirtyChangedListener(this);
        this.initCodePane();
    }

    public void read(BufferedReader bufferedReader, Object object) throws IOException {
        String string;
        String string2 = "";
        while ((string = bufferedReader.readLine()) != null) {
            string2 = string2 + string + "\n";
        }
        this.setText(string2);
        this.justLoaded = true;
    }

    private void initCodePane() {
        this.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                if (!undoableEditEvent.getEdit().getPresentationName().equals("style change")) {
                    PiCode.this.undo.addEdit(undoableEditEvent.getEdit());
                    PiCode.this.piGui.undoChangeHappened(PiCode.this.undo);
                }
            }
        });
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                int n;
                int n2 = caretEvent.getDot();
                if (n2 == (n = caretEvent.getMark())) {
                    PiCode.this.piGui.codeIsSelected(false);
                } else {
                    PiCode.this.piGui.codeIsSelected(true);
                }
                PiCode.this.removeAllHighlights();
            }
        });
    }

    public void highlight(Location location, Color color) {
        this.highlights.clear();
        this.highlights.add(new JEditTextArea.HighlightLocation(this, location, color));
        this.repaint();
    }

    public void highlight(ArrayList<Location> arrayList, Color color) {
        this.highlights.clear();
        for (Location location : arrayList) {
            this.highlights.add(new JEditTextArea.HighlightLocation(this, location, color));
        }
        this.repaint();
    }

    public void removeAllHighlights() {
        if (this.highlights.size() > 0) {
            this.highlights.clear();
            this.repaint();
        }
    }

    public boolean undo() {
        this.undo.undo();
        this.piGui.undoChangeHappened(this.undo);
        return this.undo.canUndo();
    }

    public void redo() {
        this.undo.redo();
        this.piGui.undoChangeHappened(this.undo);
    }

    public void openedNewFile() {
        this.removeAllHighlights();
        this.undo.discardAllEdits();
        this.piGui.undoChangeHappened(this.undo);
    }

    public void clear() {
        this.setText("");
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateScrollBars();
        if (this.justLoaded) {
            this.justLoaded = false;
        } else {
            this.piGui.setDirty(true);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateScrollBars();
        this.piGui.setDirty(true);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateScrollBars();
        this.piGui.setDirty(true);
    }

    @Override
    public void dirtyChanged(boolean bl) {
        if (!bl) {
            this.addDocumentChangeListener();
        }
    }

    private void addDocumentChangeListener() {
        this.getDocument().addDocumentListener(this);
    }

    private void removeDocumentChangeListener() {
        this.getDocument().removeDocumentListener(this);
    }

    @Override
    public void setSize(Dimension dimension) {
        if (dimension.width < this.getParent().getSize().width) {
            dimension.width = this.getParent().getSize().width;
        }
        super.setSize(dimension);
    }

    public void increaseFont() {
        this.painter.increaseFont();
    }

    public void decreaseFont() {
        this.painter.decreaseFont();
    }
}

