/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Config {
    private static final String CONFIG_FILE_LOCATION = System.getProperty("user.home") + "/.pivc-client";
    private static final String ENVIRONMENT_FILE_LOCATION = "ENVIRONMENT";
    private static final String[][] DEFAULTS = new String[][]{{"server_address", "pivc.jasonland.com:4242"}, {"pi_files_location", "."}, {"generate_runtime_assertions", "false"}, {"find_inductive_core", "true"}, {"show_raw_xml", "false"}, {"name", ""}, {"email_address", ""}, {"submit_to_email_address", ""}, {"auto_save_compile", "false"}};
    private static Map<String, String> settings;
    private static Set<String> validKeys;
    private static Map<String, String> environment;

    public static String getValue(String string) {
        if (Config.isValidKey(string)) {
            return settings.get(string);
        }
        throw new RuntimeException("Invalid key: " + string + ". Every key needs to be included in the defaults list.");
    }

    public static String getEnvironmentValue(String string) {
        return environment.get(string);
    }

    public static boolean environmentKeyExists(String string) {
        return environment.containsKey(string);
    }

    public static String getValueWithEnvironmentOverride(String string) {
        String string2 = environment.get(string);
        if (string2 == null) {
            return Config.getValue(string);
        }
        return string2;
    }

    public static boolean getBooleanValue(String string) {
        String string2 = Config.getValue(string);
        if ("true".equals(string2)) {
            return true;
        }
        if ("false".equals(string2)) {
            return false;
        }
        throw new RuntimeException("The hey " + string + " should be either 'true' or 'false' but is currently " + string2);
    }

    public static void setValue(String string, String string2) {
        if (!Config.isValidKey(string)) {
            throw new RuntimeException("Invalid key: " + string + ". Every key needs to be included in the defaults list.");
        }
        if (string2.indexOf(61) != -1 || string2.indexOf(10) != -1 || string2.indexOf(13) != -1) {
            throw new RuntimeException("Invalid value: " + string2 + ". Values cannot have an equals signs or line seperators.");
        }
        settings.put(string, string2);
        Config.writeConfigFile();
    }

    public static void setBooleanValue(String string, boolean bl) {
        if (bl) {
            Config.setValue(string, "true");
        } else {
            Config.setValue(string, "false");
        }
    }

    private static HashMap<String, String> getMapFromBuffer(BufferedReader bufferedReader) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.length() == 0 || string.charAt(0) == '#') continue;
                int n = string.indexOf(61);
                if (n == -1) {
                    throw new RuntimeException("Malformatted config file");
                }
                String string2 = string.substring(0, n).trim();
                String string3 = string.substring(n + 1, string.length()).trim();
                hashMap.put(string2, string3);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashMap;
    }

    public static void initConfig() {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(Utils.getURL(ENVIRONMENT_FILE_LOCATION).openStream()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        environment = Config.getMapFromBuffer(bufferedReader);
        validKeys = new HashSet<String>();
        for (String[] object : DEFAULTS) {
            if (object.length != 2) {
                throw new RuntimeException("Error: the default specification must be an array of length 2. The first element is the key and the second element is the default value.");
            }
            validKeys.add(object[0]);
        }
        boolean bl = false;
        File file = Config.getConfigFile();
        if (file.exists()) {
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            settings = Config.getMapFromBuffer(new BufferedReader(fileReader));
        } else {
            settings = new HashMap<String, String>();
            bl = true;
        }
        for (String string : settings.keySet()) {
            if (validKeys.contains(string)) continue;
            bl = true;
        }
        for (String[] stringArray : DEFAULTS) {
            if (stringArray.length != 2) {
                throw new RuntimeException("Error: the default specification must be an array of length 2. The first element is the key and the second element is the default value.");
            }
            if (settings.containsKey(stringArray[0])) continue;
            settings.put(stringArray[0], stringArray[1]);
            bl = true;
        }
        if (bl) {
            Config.writeConfigFile();
        }
    }

    private static boolean isValidKey(String string) {
        return validKeys.contains(string);
    }

    private static File getConfigFile() {
        return new File(CONFIG_FILE_LOCATION);
    }

    private static void writeConfigFile() {
        try {
            File file = Config.getConfigFile();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write("#This is the configuration file for the piVC client.");
            bufferedWriter.newLine();
            bufferedWriter.write("#Each line is of the form key=value.");
            bufferedWriter.newLine();
            bufferedWriter.write("#Lines beginning with the # character are comments.");
            bufferedWriter.newLine();
            for (Map.Entry<String, String> entry : settings.entrySet()) {
                bufferedWriter.write(entry.getKey() + "=" + entry.getValue());
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

